'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database

Private Sub Form_Open(Cancel As Integer)
    'Werte bernehmen
    Me.Rand_Oben.DefaultValue = Str(HF_Blatt_Oben)
    Me.Rand_Unten.DefaultValue = Str(HF_Blatt_Unten)
    Me.Rand_Links.DefaultValue = Str(HF_Blatt_Links)
    Me.Rand_Rechts.DefaultValue = Str(HF_Blatt_Rechts)

    'Aktuellen Bereich kenntlich machen
    Blatt1_Rot_Oben = Me.Parent.Blatt1.Top
    Blatt1_Rot_Links = Me.Parent.Blatt1.Left
    Blatt1_Rot_Hoehe = Me.Parent.Blatt1.Height
    Blatt1_Rot_Breite = Me.Parent.Blatt1.Width
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Oben = Me.Parent.Blatt2.Top
    Blatt2_Rot_Links = Me.Parent.Blatt2.Left
    Blatt2_Rot_Hoehe = Me.Parent.Blatt2.Height
    Blatt2_Rot_Breite = Me.Parent.Blatt2.Width
    Blatt2_Rot_Sichtbar = True
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub

Private Sub Rand_Links_GotFocus()
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Oben = Me.Parent.Blatt1.Top
    Blatt1_Rot_Links = Me.Parent.Blatt1.Left
    Blatt1_Rot_Hoehe = Me.Parent.Blatt1.Height
    Blatt1_Rot_Breite = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Oben = Me.Parent.Blatt2.Top
    Blatt2_Rot_Links = Me.Parent.Blatt2.Left
    Blatt2_Rot_Hoehe = Me.Parent.Blatt2.Height
    Blatt2_Rot_Breite = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Sichtbar = True
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub

Private Sub Rand_Links_KeyUp(KeyCode As Integer, Shift As Integer)
On Error GoTo Rand_Links_KeyUp_ERROR
    If CDbl(Me.Rand_Links.Text) < 0 Or CDbl(Me.Rand_Links.Text) > 3 Then
        MsgBox "Bitte geben Sie einen Zahlenwert zwischen 0 und 3 ein.", vbInformation + vbOKOnly, "Fehler"
        If CDbl(Me.Rand_Links.Text) > 3 Then
            Me.Rand_Links.Value = 3
        Else
            Me.Rand_Links.Value = 0
        End If
        Exit Sub
    End If
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Breite = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Breite = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    Me.Parent.Rote_Bereiche_Anzeigen
Rand_Links_KeyUp_ERROR:
    'Fehlerhafte Zahl ignorieren
End Sub

Private Sub Rand_Links_LostFocus()
On Error GoTo Rand_Links_LostFocus_ERROR
    'Aktuellen Daten in die Anzeige bernehmen
    HF_Blatt_Links = CDbl(Me.Rand_Links.Text)
On Error Resume Next
    Blatt1_Rot_Sichtbar = False
    Blatt2_Rot_Sichtbar = False
    Me.Parent.Rote_Bereiche_Anzeigen
    Me.Parent.Blatt1_Rand_Links.Width = 0
    Me.Parent.Blatt2_Rand_Links.Width = 0
    Me.Parent.Blatt1_Rand_Links.Width = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Links.Width = Round(CDbl(Me.Rand_Links.Text) / 5 * Twips_Faktor)
    'Elemente neue positionieren
    Me.Parent.Auswahl_Format_AfterUpdate
    Exit Sub
Rand_Links_LostFocus_ERROR:
    MsgBox "Bitte geben Sie eine gltige Zahl ein.", vbExclamation + vbOKOnly, "Fehler"
    Me.Rand_Links.SetFocus
End Sub

Private Sub Rand_Oben_GotFocus()
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Oben = Me.Parent.Blatt1.Top
    Blatt1_Rot_Links = Me.Parent.Blatt1.Left
    Blatt1_Rot_Hoehe = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Breite = Me.Parent.Blatt1.Width
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Oben = Me.Parent.Blatt2.Top
    Blatt2_Rot_Links = Me.Parent.Blatt2.Left
    Blatt2_Rot_Hoehe = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Breite = Me.Parent.Blatt2.Width
    Blatt2_Rot_Sichtbar = True
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub

Private Sub Rand_Oben_KeyUp(KeyCode As Integer, Shift As Integer)
On Error GoTo Rand_Oben_KeyUp_ERROR
    If CDbl(Me.Rand_Oben.Text) < 0 Or CDbl(Me.Rand_Oben.Text) > 3 Then
        MsgBox "Bitte geben Sie einen Zahlenwert zwischen 0 und 3 ein.", vbInformation + vbOKOnly, "Fehler"
        If CDbl(Me.Rand_Oben.Text) > 3 Then
            Me.Rand_Oben.Value = 3
        Else
            Me.Rand_Oben.Value = 0
        End If
        Exit Sub
    End If
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Hoehe = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Hoehe = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    Me.Parent.Rote_Bereiche_Anzeigen
Rand_Oben_KeyUp_ERROR:
    'Fehlerhafte Zahl ignorieren
End Sub

Private Sub Rand_Oben_LostFocus()
On Error GoTo Rand_Oben_LostFocus_ERROR
    'Aktuellen Daten in die Anzeige bernehmen
    HF_Blatt_Oben = CDbl(Me.Rand_Oben.Text)
On Error Resume Next
    Blatt1_Rot_Sichtbar = False
    Blatt2_Rot_Sichtbar = False
    Me.Parent.Rote_Bereiche_Anzeigen
    Me.Parent.Blatt1_Rand_Oben.Height = 0
    Me.Parent.Blatt2_Rand_Oben.Height = 0
    Me.Parent.Blatt1_Rand_Oben.Height = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Oben.Height = Round(CDbl(Me.Rand_Oben.Text) / 5 * Twips_Faktor)
    'Elemente neue positionieren
    Me.Parent.Auswahl_Format_AfterUpdate
    Exit Sub
Rand_Oben_LostFocus_ERROR:
    MsgBox "Bitte geben Sie eine gltige Zahl ein.", vbExclamation + vbOKOnly, "Fehler"
    Me.Rand_Oben.SetFocus
End Sub

Private Sub Rand_Rechts_GotFocus()
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Oben = Me.Parent.Blatt1.Top
    Blatt1_Rot_Links = (Me.Parent.Blatt1.Left + Me.Parent.Blatt1.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Hoehe = Me.Parent.Blatt1.Height
    Blatt1_Rot_Breite = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Oben = Me.Parent.Blatt2.Top
    Blatt2_Rot_Links = (Me.Parent.Blatt2.Left + Me.Parent.Blatt2.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Hoehe = Me.Parent.Blatt2.Height
    Blatt2_Rot_Breite = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Sichtbar = True
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub

Private Sub Rand_Rechts_KeyUp(KeyCode As Integer, Shift As Integer)
On Error GoTo Rand_Rechts_KeyUp_ERROR
    If CDbl(Me.Rand_Rechts.Text) < 0 Or CDbl(Me.Rand_Rechts.Text) > 3 Then
        MsgBox "Bitte geben Sie einen Zahlenwert zwischen 0 und 3 ein.", vbInformation + vbOKOnly, "Fehler"
        If CDbl(Me.Rand_Rechts.Text) > 3 Then
            Me.Rand_Rechts.Value = 3
        Else
            Me.Rand_Rechts.Value = 0
        End If
        Exit Sub
    End If
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Links = (Me.Parent.Blatt1.Left + Me.Parent.Blatt1.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Breite = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Links = (Me.Parent.Blatt2.Left + Me.Parent.Blatt2.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Breite = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Me.Parent.Rote_Bereiche_Anzeigen
Rand_Rechts_KeyUp_ERROR:
    'Fehlerhafte Zahl ignorieren
End Sub

Private Sub Rand_Rechts_LostFocus()
On Error GoTo Rand_Rechts_LostFocus_ERROR
    'Aktuellen Daten in die Anzeige bernehmen
    HF_Blatt_Rechts = CDbl(Me.Rand_Rechts.Text)
On Error Resume Next
    Blatt1_Rot_Sichtbar = False
    Blatt2_Rot_Sichtbar = False
    Me.Parent.Rote_Bereiche_Anzeigen
    Me.Parent.Blatt1_Rand_Rechts.Width = 0
    Me.Parent.Blatt2_Rand_Rechts.Width = 0
    Me.Parent.Blatt1_Rand_Rechts.Left = (Me.Parent.Blatt1.Left + Me.Parent.Blatt1.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt1_Rand_Rechts.Width = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Rechts.Left = (Me.Parent.Blatt2.Left + Me.Parent.Blatt2.Width) - Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Rechts.Width = Round(CDbl(Me.Rand_Rechts.Text) / 5 * Twips_Faktor)
    'Elemente neue positionieren
    Me.Parent.Auswahl_Format_AfterUpdate
    Exit Sub
Rand_Rechts_LostFocus_ERROR:
    MsgBox "Bitte geben Sie eine gltige Zahl ein.", vbExclamation + vbOKOnly, "Fehler"
    Me.Rand_Rechts.SetFocus
End Sub

Private Sub Rand_Unten_GotFocus()
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Oben = (Me.Parent.Blatt1.Top + Me.Parent.Blatt1.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Links = Me.Parent.Blatt1.Left
    Blatt1_Rot_Hoehe = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Breite = Me.Parent.Blatt1.Width
    Blatt1_Rot_Sichtbar = True
    Blatt2_Rot_Oben = (Me.Parent.Blatt2.Top + Me.Parent.Blatt2.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Links = Me.Parent.Blatt2.Left
    Blatt2_Rot_Hoehe = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Breite = Me.Parent.Blatt2.Width
    Blatt2_Rot_Sichtbar = True
    Me.Parent.Rote_Bereiche_Anzeigen
End Sub

Private Sub Rand_Unten_KeyUp(KeyCode As Integer, Shift As Integer)
On Error GoTo Rand_Unten_KeyUp_ERROR
    If CDbl(Me.Rand_Unten.Text) < 0 Or CDbl(Me.Rand_Unten.Text) > 3 Then
        MsgBox "Bitte geben Sie einen Zahlenwert zwischen 0 und 3 ein.", vbInformation + vbOKOnly, "Fehler"
        If CDbl(Me.Rand_Unten.Text) > 3 Then
            Me.Rand_Oben.Value = 3
        Else
            Me.Rand_Oben.Value = 0
        End If
        Exit Sub
    End If
    'Aktuellen Bereich anzeigen
    Blatt1_Rot_Oben = (Me.Parent.Blatt1.Top + Me.Parent.Blatt1.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt1_Rot_Hoehe = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Oben = (Me.Parent.Blatt2.Top + Me.Parent.Blatt2.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Blatt2_Rot_Hoehe = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Me.Parent.Rote_Bereiche_Anzeigen
Rand_Unten_KeyUp_ERROR:
    'Fehlerhafte Zahl ignorieren
End Sub

Private Sub Rand_Unten_LostFocus()
On Error GoTo Rand_Unten_LostFocus_ERROR
    'Aktuellen Daten in die Anzeige bernehmen
    HF_Blatt_Unten = CDbl(Me.Rand_Unten.Text)
On Error Resume Next
    Blatt1_Rot_Sichtbar = False
    Blatt2_Rot_Sichtbar = False
    Me.Parent.Rote_Bereiche_Anzeigen
    Me.Parent.Blatt1_Rand_Unten.Height = 0
    Me.Parent.Blatt2_Rand_Unten.Height = 0
    Me.Parent.Blatt1_Rand_Unten.Top = (Me.Parent.Blatt1.Top + Me.Parent.Blatt1.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt1_Rand_Unten.Height = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Unten.Top = (Me.Parent.Blatt2.Top + Me.Parent.Blatt2.Height) - Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    Me.Parent.Blatt2_Rand_Unten.Height = Round(CDbl(Me.Rand_Unten.Text) / 5 * Twips_Faktor)
    'Elemente neue positionieren
    Me.Parent.Auswahl_Format_AfterUpdate
    Exit Sub
Rand_Unten_LostFocus_ERROR:
    MsgBox "Bitte geben Sie eine gltige Zahl ein.", vbExclamation + vbOKOnly, "Fehler"
    Me.Rand_Unten.SetFocus
End Sub
